﻿var Dialog = {
    modal: "",
    timerid: 0,
    bActiveDialog: false ,
    countdown: null,
    cssmodal: "<link type='text/css' href='/Voxco.Agent/css/modal.css' rel='stylesheet' media='screen' />",
    context: null,
    title: "Message",
    properties: { timeout: 0, alerttitle: "Warning", dialogtitle: "Message", onTineout:this.onTimeout, onClick: null, onClose: null },


    init: function (_properties) {
        if (typeof _properties.document == "object")
            this.context = _properties.document;

        if (typeof _properties.alerttitle == "string")
            this.properties.alerttitle = _properties.alerttitle;

        if (typeof _properties.dialogtitle == "string")
            this.properties.dialogtitle = _properties.dialogtitle;
    },


    importcss: function () {
        var head = this.context.head || this.context.getElementsByTagName('head')[0];
        $(head).append(Dialog.cssmodal);
    },

    //
    //  Fermeture du dialogue
    //
    closeDialog: function ( bTimeout ) {

        if (this.bActiveDialog == false)
            return;    

        Dialog.modal.style.display = "none";
        if (Dialog.timerid != 0)
            clearInterval(Dialog.timerid);

        this.bActiveDialog = false;
        Dialog.timerid = 0;
        try {
            if (typeof Dialog.properties.onClose == "function")
                Dialog.properties.onClose(bTimeout);
        }
        catch (e) {

        }
    },

    //
    //  Appele par le click de l'accepte du dialogue
    //
    onAccept: function () {

        Dialog.closeDialog( false );
        if (typeof Dialog.properties.onClick != "function")
            return;

        Dialog.properties.onClick(true);
        return
    },


    onTimeout: function () {
        Dialog.closeDialog( true );
        return
    },

 
    //
    //  Appele par le click de cancel du dialogue ... Seulement necessaire pour un dialogue de confirmation avec
    //  le bouton accept et cancel . Dans certain cas le cancel n'est pas necessaire au dialogue
    //
    onCancel: function () {

        Dialog.closeDialog( false );
        if (typeof Dialog.properties.onClick != "function")
            return;

        Dialog.properties.onClick(false);
        return;
    },

    //
    //  Permet le decompte du chronometre du dialogue
    //
    onInterval: function () {

        if (Dialog.properties.timeout == 0)
        {
            Dialog.closeDialog(true);
            return;
        }
            
        Dialog.properties.timeout--;
        var timerElement = Dialog.context.getElementById('countdown');
        if (timerElement != null)
            timerElement.innerText = Dialog.properties.timeout + " sec";
    },

  
    //
    // Affichage d'un alerte.... sans doute pas necessaire pour le moment
    //
    showAlert: function (properties, message)
    {
        this.showDialog(properties, message);
        return 
    },

    show: function (properties, message) {

        if (typeof properties != "object")
            return;

        this.bActiveDialog = true;
        try {
            var timerElement = Dialog.context.getElementById('countdown');
            if (timerElement != null)
                timerElement.style.display = "none";

            if (typeof properties.timeout == "number" && properties.timeout > 0) {
                //
                //  Si une timeout est associe au dialogue , nous demarrons un timer et nous mettons la zone texte
                //  disponible 
                //

                if (timerElement != null) {
                    timerElement.style.display = "inline-block";
                    timerElement.innerText = properties.timeout + " sec"
                }

                Dialog.properties.timeout = properties.timeout;
                Dialog.timerid = setInterval(Dialog.onInterval, 1000);
            }



            this.properties.onClick = properties.onClick;
            this.properties.onClose = properties.onClose;

            Dialog.modal = Dialog.context.getElementById('modal');

            if (typeof properties.title == "string" && properties.title.length != 0) {
                //
                //  Permet de changer le titre 
                //
                var titleelement = Dialog.context.getElementById('header-title');
                titleelement.innerText = properties.title;
            }

            var acceptElement = Dialog.context.getElementById('modal-accept');

            if (typeof properties.accept == "string" && properties.accept.length != 0) {
                //
                //  Affichage du bouton accepte...
                //

                if (typeof acceptElement == "object") {
                    acceptElement.style.display = "inline-block"
                    acceptElement.value = properties.accept;
                    acceptElement.onclick = Dialog.onAccept;
                }

            }

            var cancelElement = Dialog.context.getElementById('modal-cancel');
            if (typeof cancelElement == "object")
                cancelElement.style.display = "none";

            if (typeof properties.cancel == "string" && properties.cancel.length != 0) {
                //
                //  Affichage du bouton cancel... Par defaut il n'apparait pas a l'ecran
                //
                cancelElement.style.display = "inline-block"
                cancelElement.value = properties.cancel;
                cancelElement.onclick = Dialog.onCancel;
            }

            //
            //  mise a jour du texte
            //

            var text = Dialog.context.getElementById('text');
            if (typeof text == "object")
                text.innerHTML = message;

            Dialog.modal.style.display = "block";
            acceptElement.focus();
        }
        catch (e) {

        }
      
    },

    //
    // Affichage d'un dialogue 
    //

    showDialog: function( properties , message )
    {
        if (typeof properties != "object")
            return;
     
        if (typeof properties.context == "object")
            this.context = properties.context;

        if (typeof properties.title != "string")
            properties.title = this.title;
        //
        //  Creation du dialogue si pas present . Ajout dynamique des div necessaire au dialogue
        //
        var bDialogPresent = this.createElement();
        if (bDialogPresent == true) {
            this.show(properties, message);
            return;
        }

        //
        // aucun dialog present , donc nous devons importer dynamiquement le CSS . Le timeout
        // de 50 ms donne le temps au CSS d'etre importe
        //
        setTimeout(function () { Dialog.show(properties, message);}, 50);
    },


    //
    //  construction du dialogue en fonction du fichier modal.css
    //
   
    builtinHTML: function () {
        var builtin = "";
        builtin += "<div class=\"modal\" id=\"modal\" tabindex=\"0\">"
        builtin += "   <div class=\"modal-content\">";
        builtin += "        <div class=\"modal-header\"><h2 id=\"header-title\">Message</h2></div>";
        builtin += "        <div class=\"modal-body\">";
        builtin += "               <p id=\"text\"></p>";
        builtin += "        </div>";
        builtin += "    <div class=\"modal-footer\">";
        builtin += "        <label class=\"countdown\" id=\"countdown\"></label>";
        builtin += "        <input type=\"button\" id=\"modal-accept\" class=\"button primary dialog yes\"value=\"\" onclick=\"Dialog.onAccept()\"/>";
        builtin += "        <input type=\"button\" id=\"modal-cancel\" class=\"button primary dialog no\" value=\"\" onclick=\"Dialog.onCancel()\"/>";
        builtin += "    </div>";
        builtin += "</div></div>";

        return builtin;
    },


    //
    //  Insertion des elements necessaire a l'affichage du Dialogue 
    //
    createElement: function () {

        try {
            var bDialogPresent = true;
            if (typeof this.context != "object" || this.context == null)
                return bDialogPresent;

            //
            //  Si deja present on ne fait rien
            //
            var DynamicDialog = this.context.getElementById("DynamicModal");
            if (DynamicDialog != null)
                return bDialogPresent;

            this.importcss();

            var divelement = this.context.createElement("div");
            divelement.style.visibility = 'visible';
            divelement.id = 'DynamicModal';
            divelement.innerHTML = this.builtinHTML();
            this.context.body.appendChild(divelement);
            return false;
        }
        catch (e) {

        }
        

       
    }
};